"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var getSvgJsx_exports = {};
__export(getSvgJsx_exports, {
  getSvgJsx: () => getSvgJsx
});
module.exports = __toCommonJS(getSvgJsx_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_tlschema = require("@tldraw/tlschema");
var import_react = require("react");
var import_SvgExportContext = require("./types/SvgExportContext");
async function getSvgJsx(editor, shapes, opts = {}) {
  const ids = typeof shapes[0] === "string" ? shapes : shapes.map((s) => s.id);
  if (ids.length === 0) return;
  if (!window.document) throw Error("No document");
  const {
    scale = 1,
    background = false,
    padding = editor.options.defaultSvgPadding,
    preserveAspectRatio = false
  } = opts;
  const isDarkMode = opts.darkMode ?? editor.user.getIsDarkMode();
  const theme = (0, import_tlschema.getDefaultColorTheme)({ isDarkMode });
  const shapeIdsToInclude = editor.getShapeAndDescendantIds(ids);
  const renderingShapes = editor.getUnorderedRenderingShapes(false).filter(({ id }) => shapeIdsToInclude.has(id));
  let bbox = null;
  if (opts.bounds) {
    bbox = opts.bounds;
  } else {
    for (const { id } of renderingShapes) {
      const maskedPageBounds = editor.getShapeMaskedPageBounds(id);
      if (!maskedPageBounds) continue;
      if (bbox) {
        bbox.union(maskedPageBounds);
      } else {
        bbox = maskedPageBounds.clone();
      }
    }
  }
  if (!bbox) return;
  const singleFrameShapeId = ids.length === 1 && editor.isShapeOfType(editor.getShape(ids[0]), "frame") ? ids[0] : null;
  if (!singleFrameShapeId) {
    bbox.expandBy(padding);
  }
  const w = bbox.width * scale;
  const h = bbox.height * scale;
  try {
    document.body.focus?.();
  } catch (e) {
  }
  const defChildren = [];
  const exportDefPromisesById = /* @__PURE__ */ new Map();
  const exportContext = {
    isDarkMode,
    addExportDef: (def) => {
      if (exportDefPromisesById.has(def.key)) return;
      const promise = (async () => {
        const element = await def.getElement();
        if (!element) return;
        defChildren.push(/* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react.Fragment, { children: element }, defChildren.length));
      })();
      exportDefPromisesById.set(def.key, promise);
    }
  };
  const unorderedShapeElements = (await Promise.all(
    renderingShapes.map(async ({ id, opacity, index, backgroundIndex }) => {
      if (id === singleFrameShapeId) return [];
      const shape = editor.getShape(id);
      if (editor.isShapeOfType(shape, "group")) return [];
      const util = editor.getShapeUtil(shape);
      let toSvgResult = await util.toSvg?.(shape, exportContext);
      let toBackgroundSvgResult = await util.toBackgroundSvg?.(shape, exportContext);
      if (!toSvgResult && !toBackgroundSvgResult) {
        const bounds = editor.getShapePageBounds(shape);
        toSvgResult = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          "rect",
          {
            width: bounds.w,
            height: bounds.h,
            fill: theme.solid,
            stroke: theme.grey.pattern,
            strokeWidth: 1
          }
        );
      }
      let pageTransform = editor.getShapePageTransform(shape).toCssString();
      if ("scale" in shape.props) {
        if (shape.props.scale !== 1) {
          pageTransform = `${pageTransform} scale(${shape.props.scale}, ${shape.props.scale})`;
        }
      }
      if (toSvgResult) {
        toSvgResult = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { transform: pageTransform, opacity, children: toSvgResult }, shape.id);
      }
      if (toBackgroundSvgResult) {
        toBackgroundSvgResult = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { transform: pageTransform, opacity, children: toBackgroundSvgResult }, `bg_${shape.id}`);
      }
      const pageMask = editor.getShapeMask(shape.id);
      if (pageMask) {
        const pageMaskId = `mask_${shape.id.replace(":", "_")}`;
        defChildren.push(
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("clipPath", { id: pageMaskId, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("path", { d: `M${pageMask.map(({ x, y }) => `${x},${y}`).join("L")}Z` }) }, defChildren.length)
        );
        if (toSvgResult) {
          toSvgResult = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { clipPath: `url(#${pageMaskId})`, children: toSvgResult }, shape.id);
        }
        if (toBackgroundSvgResult) {
          toBackgroundSvgResult = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("g", { clipPath: `url(#${pageMaskId})`, children: toBackgroundSvgResult }, `bg_${shape.id}`);
        }
      }
      const elements = [];
      if (toSvgResult) {
        elements.push({ zIndex: index, element: toSvgResult });
      }
      if (toBackgroundSvgResult) {
        elements.push({ zIndex: backgroundIndex, element: toBackgroundSvgResult });
      }
      return elements;
    })
  )).flat();
  await Promise.all(exportDefPromisesById.values());
  const svg = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_SvgExportContext.SvgExportContextProvider, { editor, context: exportContext, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    "svg",
    {
      preserveAspectRatio: preserveAspectRatio ? preserveAspectRatio : void 0,
      direction: "ltr",
      width: w,
      height: h,
      viewBox: `${bbox.minX} ${bbox.minY} ${bbox.width} ${bbox.height}`,
      strokeLinecap: "round",
      strokeLinejoin: "round",
      style: {
        backgroundColor: background ? singleFrameShapeId ? theme.solid : theme.background : "transparent"
      },
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)("defs", { children: defChildren }),
        unorderedShapeElements.sort((a, b) => a.zIndex - b.zIndex).map(({ element }) => element)
      ]
    }
  ) });
  return { jsx: svg, width: w, height: h };
}
//# sourceMappingURL=getSvgJsx.js.map
